import java.util.*;

// Evaluator class to analyze poker hands
class PokerHandEvaluator {

    public static String evaluate(List<Card> hand) {
        List<String> ranks = new ArrayList<>();
        List<String> suits = new ArrayList<>();

        for (Card c : hand) {
            if (!(c instanceof PlayingCard)) continue;
            ranks.add(c.getRank());
            suits.add(c.getSuit());
        }

        Map<String, Long> rankCounts = ranks.stream()
                .collect(HashMap::new, (m, v) -> m.put(v, m.getOrDefault(v, 0L)+1), Map::putAll);

        boolean flush = new HashSet<>(suits).size() == 1;

        List<Integer> rankValues = ranks.stream().map(PokerHandEvaluator::rankValue).sorted().toList();
        boolean straight = true;
        for (int i = 1; i < rankValues.size(); i++)
            if (rankValues.get(i) - rankValues.get(i - 1) != 1)
                straight = false;

        boolean royal = straight && flush && rankValues.get(0) == 10;

        if (royal) return "Royal Flush!";
        if (straight && flush) return "Straight Flush!";
        if (rankCounts.containsValue(4L)) return "Four of a Kind!";
        if (rankCounts.containsValue(3L) && rankCounts.containsValue(2L)) return "Full House!";
        if (flush) return "Flush!";
        if (straight) return "Straight!";
        if (rankCounts.containsValue(3L)) return "Three of a Kind!";
        long pairs = rankCounts.values().stream().filter(v -> v == 2).count();
        if (pairs == 2) return "Two Pair!";
        if (pairs == 1) return "One Pair!";
        return "High Card: " + highCard(rankValues);
    }

    private static int rankValue(String rank) {
        return switch (rank) {
            case "2" -> 2; case "3" -> 3; case "4" -> 4; case "5" -> 5;
            case "6" -> 6; case "7" -> 7; case "8" -> 8; case "9" -> 9;
            case "10" -> 10; case "J" -> 11; case "Q" -> 12; case "K" -> 13; case "A" -> 14;
            default -> 0;
        };
    }

    private static String highCard(List<Integer> values) {
        int max = Collections.max(values);
        return switch (max) {
            case 14 -> "A"; case 13 -> "K"; case 12 -> "Q"; case 11 -> "J";
            default -> String.valueOf(max);
        };
    }
}