// Main game logic
public static void main(String[] args) throws IOException {
    System.out.println("🎴 Welcome to Java Poker!\n");

    while (true) {
        Deck deck = new Deck();
        deck.shuffle();

        List<Card> hand = deck.deal(5);

        System.out.println("Dealing your cards...\n");
        System.out.print("Your hand: ");

        for (Card c : hand) {
            c.draw(500); // use static polymorphism (overloaded method)
            System.out.print(c.colored() + " ");
        }

        System.out.println("\n➡️ Result: " + PokerHandEvaluator.evaluate(hand));


        System.out.println("\nPress [Enter] to play again or [Esc] to exit...");
        int key = System.in.read();
        if (key == 27) { // ESC key
            System.out.println("👋 Thanks for playing!");
            break;
        }
        while (System.in.available() > 0) System.in.read();
        System.out.println();
    }
}