import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

// Deck class manages card collection and shuffling
class Deck {
    private final List<Card> cards = new ArrayList<>();
    private final String[] suits = {"♠", "♥", "♦", "♣"};
    private final String[] ranks = {"2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K", "A"};

    public Deck() {
        for (String suit : suits)
            for (String rank : ranks)
                cards.add(new PlayingCard(suit, rank));
        // Optional Joker
        // cards.add(new Joker());
    }

    public void shuffle() {
        Collections.shuffle(cards);
    }

    public List<Card> deal(int n) {
        List<Card> hand = new ArrayList<>(cards.subList(0, n));
        cards.subList(0, n).clear();
        return hand;
    }
}