// Abstract base class implementing the Drawable interface
abstract class Card implements Drawable {
    protected String suit;
    protected String rank;

    public Card(String suit, String rank) {
        this.suit = suit;
        this.rank = rank;
    }

    // Static polymorphism - overloaded draw() with delay
    public void draw(int delayMs) {
        draw(); // calls dynamic version (overridden in subclass)
        try {
            Thread.sleep(delayMs);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getSuit() { return suit; }
    public String getRank() { return rank; }

    @Override
    public String toString() { return rank + suit; }

    // Add colored output for red suits
    public String colored() {
        if (suit.equals("♥") || suit.equals("♦")) {
            return "\u001B[31m" + this + "\u001B[0m"; // red color for hearts/diamonds
        } else {
            return this.toString(); // default black
        }
    }
}