public class KaprekarRoutine {

    public static final int KAPREKAR_CONSTANT = 6174;

    /**
     * Calculates how many steps are needed to reach Kaprekar's constant (6174)
     * from the given number. The number must be a four-digit integer
     * containing at least two different digits.
     *
     * @param number a four-digit number
     * @return the number of steps required to reach 6174
     * @throws IllegalArgumentException if the input is not valid
     */
    public int stepsToKaprekar(int number) {
        if (number < 1000 || number > 9999) {
            throw new IllegalArgumentException("The number must be four digits.");
        }
        if (allDigitsSame(number)) {
            throw new IllegalArgumentException("The number must have at least two different digits.");
        }

        int steps = 0;
        while (number != KAPREKAR_CONSTANT) {
            number = kaprekarStep(number);
            steps++;
            if (steps > 7) { // it should never exceed 7 steps
                throw new IllegalStateException("Kaprekar's constant cannot be reached.");
            }
        }
        return steps;
    }

    private int kaprekarStep(int number) {
        String digits = String.format("%04d", number);

        char[] arr = digits.toCharArray();
        java.util.Arrays.sort(arr);

        int small = Integer.parseInt(new String(arr));
        int large = Integer.parseInt(new StringBuilder(new String(arr)).reverse().toString());

        return large - small;
    }

    private boolean allDigitsSame(int number) {
        String s = String.valueOf(number);
        return s.chars().distinct().count() == 1;
    }
}
